<?php


namespace Cms\Client\Member\Transformer;

use Move\ObjectMapper\ObjectTransformer;
use POM\DomainObjectInterface;

/**
 * Class MemberTransformer
 * @package Cms\Client\Member\Transformer
 */
class MemberTransformer extends ObjectTransformer
{

    /**
     * @param DomainObjectInterface $object
     * @return array
     */
    public function transform(DomainObjectInterface $object)
    {
        $result = parent::transform($object);

        // ajout de donnée d'attribut par clé/val
        $result['attrs'] = [];
        $result['attrs_by_scope'] = [];
        if (!empty($result['attributes'])) {
            foreach ($result['attributes'] as $attribute) {
                $result['attrs'][$attribute['name']] = $attribute['value'];
                $result['attrs_by_scope'][$attribute['scope_id']][$attribute['name']] = $attribute['value'];
            }
        }

        return $result;
    }
}
