<?php

namespace Cms\Client\Stats;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Model\Stats\AlsoViewedModel;
use POM\DomainObjectInterface;

/**
 * Class AlsoViewedClient
 * @package Cms\Client\Stats
 */
class AlsoViewedClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'also-viewed';

    /**
     * @param array $dataset
     * @return DomainObjectInterface
     */
    public function handleData($dataset = [])
    {
        return (new AlsoViewedModel())->populate($dataset);
    }

    /**
     * @param array $queryParams
     * @return AlsoViewedModel[]|CmsApiIndexIterator
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param string $itemId
     * @return array array of item ids
     */
    public function getAlsoViewedItemIds($itemId) : array
    {
        $results = $this->getBuilder()
            ->setFilter('item_id', $itemId)
            ->getIndex(-1);
        $itemListIds = array_map(function (AlsoViewedModel $model) {
            return array_fill_keys($model->item_json_ids->getArrayCopy(), $model->count);
        }, iterator_to_array($results));
        if (empty($itemListIds)) {
            return [];
        }
        $sums = array_merge(...$itemListIds);
        unset($sums[$itemId]);
        foreach ($sums as $key => &$init) {
            $init = array_reduce($itemListIds, function ($carry, $item) use ($key) {
                return $carry + ($item[$key] ?? 0);
            }) ?: $init;
        }
        unset($init);
        arsort($sums);
        return array_keys($sums);
    }

    /**
     * @param array $listIds
     * @param null|string $userId
     * @return \Cms\Model\Stats\AlsoViewedModel|\POM\DomainObjectInterface
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function addAlsoViewedStat(array $listIds, $userId = null)
    {
        $object = $this->handleData([
            'user_uuid' => $userId,
        ]);

        // envoi de la stats
        $result = $this->createObjectFromClient(
            $object,
            $this->basePath,
            [
                'item_json_ids' => $listIds,
            ]
        );
        return $result;
    }
}
