<?php

namespace Cms\Plugin\Article\Category;

use Cms\Model\AbstractConfigModel;
use Cms\Model\Article\Category\CategoryPluginType;

/**
 * Class PluginConfigFactory
 * @package Cms\Plugin\Article\Category
 */
class PluginConfigFactory
{

    /**
     * @param CategoryPluginType|string $pluginType
     * @param array $dataset
     * @return AbstractConfigModel|null
     */
    public static function createFromPluginType($pluginType, array $dataset = [])
    {
        if (!$pluginType instanceof CategoryPluginType
            && !CategoryPluginType::isValid($pluginType)
        ) {
            throw new \InvalidArgumentException('type unknown');
        }
        switch ($pluginType) {
            case CategoryPluginType::SMART_AD:
                return (new PluginSmartAdConfig())->populate($dataset, true);
                break;
            case CategoryPluginType::COLOR:
                return (new PluginColorConfig())->populate($dataset, true);
                break;
            default:
                return null;
                break;
        }
    }
}
