<?php


namespace Move\Http\Route;

use League\Route\Route;
use League\Route\RouteGroup;
use League\Route\Strategy\StrategyInterface;

/**
 * Class LeagueRouteGroupRegistrer
 * @package Move\Http\Route
 */
class LeagueRouteGroupRegistrer
{
    /**
     * @var array
     */
    private $routeList;

    /**
     * @var StrategyInterface|null
     */
    private $strategyObj;

    /**
     * GroupRegistrer constructor.
     * @param array $routeList
     * @param StrategyInterface|null $strategyObj
     */
    public function __construct(array $routeList = [], StrategyInterface $strategyObj = null)
    {
        $this->routeList = $routeList;
        $this->strategyObj = $strategyObj;
    }

    /**
     * @param RouteGroup $group
     */
    public function map(RouteGroup $group)
    {
        foreach ($this->routeList as $routeInfo) {
            if (!\is_array($routeInfo) || count($routeInfo) !== 3) {
                throw new \InvalidArgumentException('routeInfo is invalid');
            }
            /** @var Route $route */
            $route = \call_user_func_array([$group, 'map'], $routeInfo);
            if ($this->strategyObj instanceof StrategyInterface) {
                $route->setStrategy($this->strategyObj);
            }
        }
    }
}
