<?php

namespace Move\Http\Strategy\Serializer;

use League\Fractal\Manager;
use PHPUnit\Framework\TestCase;
use Psr\Http\Message\ResponseInterface;

/**
 * Class FractalAdapterSerializerTest
 * @package Move\Http\Strategy\Serializer
 */
class FractalAdapterSerializerTest extends TestCase
{
    private $manager;
    private $serializer;
    private $responseInterface;

    private $dataset = ['dummy' => 'data', 'key' => 'value'];
    private $expectedResult = '{"dummy":"data","key":"value"}';

    /**
     * @inheritdoc
     */
    protected function setUp()
    {
        $this->manager = new Manager();
        $this->serializer = new JsonSerializer();
        $this->responseInterface = $this->getMockBuilder(ResponseInterface::class)
            ->getMock();
    }

    /**
     * @covers FractalAdapterSerializer::__construct
     * @return FractalAdapterSerializer
     */
    public function testConstruct()
    {
        $serializer = new FractalAdapterSerializer(
            $this->manager,
            $this->serializer
        );

        $this->assertInstanceOf(FractalAdapterSerializer::class, $serializer);
        return $serializer;
    }

    /**
     * @depends testConstruct
     * @covers FractalAdapterSerializer::serialize
     * @param FractalAdapterSerializer $serializer
     */
    public function testSerialize(FractalAdapterSerializer $serializer)
    {
        $result = $serializer->serialize($this->dataset, $this->responseInterface);
        $this->assertEquals($this->expectedResult, $result);
    }

    /**
     * @depends testConstruct
     * @covers FractalAdapterSerializer::__invoke
     * @param FractalAdapterSerializer $serializer
     */
    public function testInvoke(FractalAdapterSerializer $serializer)
    {
        $serialized = call_user_func(
            $serializer,
            $this->dataset,
            $this->responseInterface
        );

        $this->assertEquals($this->expectedResult, $serialized);
    }
}
