<?php

namespace Cms\Extension\Component;

use Cms\Client\Geodata\Helper\GeodataHelperTrait;
use Cms\Client\Geodata\Model\AdminRestfulModel;
use Cms\Client\Service\GeodataService;
use Cms\Client\Service\GeodataServiceAwareTrait;
use League\Plates\Template\Template;
use Move\Template\Component\AbstractComponent;

/**
 * Class GeoAdminComponent
 * @package Cms\Extension\Component
 */
class GeoAdminComponent extends AbstractComponent
{
    use GeodataServiceAwareTrait;
    use GeodataHelperTrait;

    /**
     * GeoAdminComponent constructor.
     * @param \Cms\Client\Service\GeodataService $geodataService
     */
    public function __construct(GeodataService $geodataService)
    {
        $this->functionName = 'geoadmins';
        $this->setGeodataService($geodataService);
    }

    /**
     * @param Template $template
     * @param array $data
     * @throws \DomainException
     */
    protected function assignData(Template $template, $data = [])
    {
        $level = $data['geolevel'] ?? null;
        if (!empty($data['admin_ids']) && \is_array($data['admin_ids'])) {
            try {
                $results = $this->getGeodataService()->getAdminClient()
                    ->fetchBulkItems($data['admin_ids']);
                $data['geoadmins'] = $results;
            } catch (\Exception $e) {
                trigger_error((string)$e);
            }
        } else {
            $countryCode = $data['country_code'] ?? null;
            if ($countryCode) {
                try {
                    $results = $this->getGeodataAdminLevelList($level, $countryCode);
                    $data['geoadmins'] = $results;
                } catch (\Throwable $e) {
                    trigger_error((string)$e);
                }
            }
        }

        // trie des resultats
        if (!empty($data['geoadmins'])) {
            if (isset($data['order_by']['name'])) {
                $dataByName = [];
                foreach ($data['geoadmins'] as $k => $adminModel) {
                    if ($adminModel instanceof AdminRestfulModel) {
                        $dataByName[$k] = $adminModel->name_slug;
                    }
                }
                array_multisort($dataByName, $data['order_by']['name'] ?: SORT_ASC, SORT_STRING, $data['geoadmins']);
            } elseif (isset($data['order_by']['code'])) {
                $dataByCode = [];
                foreach ($data['geoadmins'] as $k => $adminModel) {
                    if ($adminModel instanceof AdminRestfulModel) {
                        $dataByCode[$k] = $adminModel->code_simple;
                    }
                }
                array_multisort($dataByCode, $data['order_by']['code'] ?: SORT_ASC, SORT_STRING, $data['geoadmins']);
            }
        }

        $data['geoadmins_by_parent'] = [];
        if ($level > 1 || !$level) {
            foreach ($data['geoadmins'] ?? [] as $adminModel) {
                if ($adminModel instanceof AdminRestfulModel && $adminModel->parent_id) {
                    $data['geoadmins_by_parent'][$adminModel->parent_id][] = $adminModel;
                }
            }
        }

        $template->data($data);
    }
}
