<?php


namespace Cms\Filesystem\Strategy;

/**
 * Interface RenameStrategyInterface
 * @package Cms\Filesystem\Strategy
 */
interface RenameStrategyInterface
{

    /**
     * @param string $filename
     * @return string
     */
    public function getDestinationBasename($filename) : string;

    /**
     * @param string $filename
     * @return string
     */
    public function getDestinationPath($filename) : string;

    /**
     * @param string $filePath
     * @param bool $override
     * @return string
     */
    public function rename($filePath, $override = false) : string;
}
