<?php

namespace Cms\LinkResource\Provider;

/**
 * Class AbstractProviderAdapter
 * @package Cms\LinkResource\Provider
 */
abstract class AbstractProviderAdapter implements ProviderAdapterInterface
{

    /** @var  string */
    protected $identifier;

    /** @var  array */
    protected $types = [];

    /** @var  array */
    protected $aliases = [];

    /**
     * @return string
     * @throws \UnexpectedValueException
     */
    public function getIdentifier() : string
    {
        if (empty($this->identifier)) {
            throw new \UnexpectedValueException('identifier must be set');
        }
        return (string)$this->identifier;
    }

    /**
     * @param string $name
     * @return bool
     * @throws \UnexpectedValueException
     */
    public function hasName($name) : bool
    {
        if ($name === $this->getIdentifier()) {
            return true;
        }
        if (!\is_array($this->aliases)) {
            throw new \UnexpectedValueException('aliases must be an array');
        }
        $aliases = array_merge([$this->getIdentifier()], $this->aliases);
        return \in_array($name, $aliases);
    }

    /**
     * @param string $type
     * @return bool
     */
    public function hasType($type) : bool
    {
        if (empty($this->types)) {
            return false;
        }
        return \is_array($this->types)
            ? \in_array((string)$type, $this->types)
            : (string)$this->types === (string)$type;
    }
}
