<?php

namespace Cms\Model\Campsite;

use POM\DomainObjectAbstract;

/**
 * Class CampsitePackageModel
 * @package Cms\Model\Campsite
 * @property int $id
 * @property int $campsite_id
 * @property string $name
 * @property \Cms\Model\Campsite\CampsiteProductCategory $category
 * @property int $season_year
 * @property \Cms\Model\Campsite\CampsiteSeasonPeriod $season_period
 * @property string $amount
 * @property bool $is_free
 * @property string $duration
 * @property \Cms\Model\Campsite\CampsitePriceDurationType $duration_type
 * @property string $note
 */
class CampsitePackageModel extends DomainObjectAbstract
{

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $campsite_id;

    /** @var  string */
    protected $name;

    /** @var  \Cms\Model\Campsite\CampsitePackageCategory */
    protected $category;

    /** @var  int */
    protected $season_year;

    /** @var  \Cms\Model\Campsite\CampsiteSeasonPeriod */
    protected $season_period;

    /** @var  string */
    protected $amount;

    /** @var  bool */
    protected $is_free;

    /** @var  string */
    protected $duration;

    /** @var  \Cms\Model\Campsite\CampsitePriceDurationType */
    protected $duration_type;

    /** @var  string */
    protected $note;

    /**
     * @param $name
     * @param $value
     */
    public function propertySet($name, $value)
    {
        if ($name === 'amount') {
            $value = str_replace(',', '.', $value);
        }
        parent::propertySet($name, $value);
    }
}
