<?php


namespace Cms\Search\Address;

use Cms\Search\Provider\Elastica\ElasticSearchResultSet;
use function Cms\Utils\geo_center;
use Lvht\GeoHash;

/**
 * Class AddressSearchQueryHelper
 * @package Cms\Search\Address
 */
class AddressSearchQueryHelper
{

    /**
     * @param \Cms\Search\Provider\Elastica\ElasticSearchResultSet $results
     * @param int|null $totalCount
     * @return array
     * @throws \InvalidArgumentException
     */
    public static function getGeogrid(
        ElasticSearchResultSet $results,
        int &$totalCount = null
    ) : array {
        $totalCount = 0;
        $geoGrid = [];
        // récuperation de l'aggregat
        $geoZoom = $results->getElasticAggregation(
            AddressSearchQueryBuilder::AGG_GEO_ZOOM
        );
        foreach ($geoZoom as $item) {
            $centerPoint = $item['centroid_' . AddressSearchQueryBuilder::AGG_GEO_ZOOM]['location'] ?? null;
            if (isset($centerPoint['lat'], $centerPoint['lon'])) {
                $centerPoint = [$centerPoint['lat'], $centerPoint['lon']];
            }
            $totalCount += $item['doc_count'];
            // récuperation du centre par le geohash
            if ($centerPoint === null) {
                [$nw, , $se,] = GeoHash::getRect($item['key']);
                $centerPoint = geo_center($nw, $se);
                $centerPoint = [$centerPoint->getLat(), $centerPoint->getLng()];
            }
            $geoGrid[] = [
                'geo_hash' => $item['key'],
                'geo_point' => $centerPoint,
                'count' => $item['doc_count'],
            ];
        }
        return $geoGrid;
    }
}
