<?php

namespace Cms\Search\Mapping;

/**
 * Trait GeoAdminDocumentTrait
 * @package Cms\Search\Mapping
 */
trait GeoAdminDocumentTrait
{

    /**
     * @param array $adminArray
     * @return array
     */
    private static function buildGeoAdminMapping(array $adminArray) : array
    {
        $defaulti18n = [
            'language' => 'fre',
            'name' => $adminArray['name'],
            'name_slug' => $adminArray['name_slug'],
        ];
        return [
            'id' => $adminArray['id'],
            'parent_id' => $adminArray['parent_id'],
            'admin_level' => $adminArray['level'],
            'admin_code_simple' => $adminArray['code_simple'],
            'admin_code_concat' => $adminArray['code_concat'],
            'admin_code_parent' => $adminArray['code_parent'],
            'admin_country_code' => $adminArray['country_alpha2'],
            'admin_name' => $adminArray['name'],
            'admin_slug' => $adminArray['name_slug'],
            'admin_name_i18n' => array_map(function ($i18n) use ($adminArray) {
                return [
                    'id' => $adminArray['id'],
                    'language' => $i18n['language'],
                    'admin_name' => $i18n['name'],
                    'admin_slug' => $i18n['name_slug'],
                ];
            }, $adminArray['i18n'] ?: [$defaulti18n]),
        ];
    }
}
