<?php


namespace Cms\Search;

/**
 * Interface SearchClientAdapterInterface
 * @package Cms\Search
 */
interface SearchClientAdapterInterface
{
    /**
     * @param string $indexName
     * @param mixed $query
     * @param array $opts
     * @param int $limit
     * @param int $page
     * @return ResultSetInterface
     */
    public function searchArray(
        string $indexName,
        array $query,
        array $opts = [],
        $limit = 10,
        $page = 1
    ) : ResultSetInterface;

    /**
     * @param string $indexName
     * @param mixed $query
     * @param array $opts
     * @param int $limit
     * @param int $page
     * @return ResultSetInterface
     */
    public function searchString(
        string $indexName,
        string $query,
        array $opts = [],
        $limit = 10,
        $page = 1
    ) : ResultSetInterface;
}
