<?php

namespace Move\ObjectMapper;

use POM\Service\CursorPdo;

/**
 * Class SqlQueryMapperTrait
 * @package Move\ObjectMapper
 */
trait SqlQueryMapperTrait
{
    use RowToObjectHandleTrait;
    use EntityTableAwareTrait;

    /**
     * @param string|array|null $fieldList
     * @param string|null $tableName
     * @return string
     */
    protected function getSelectForQuery($fieldList = '*', $tableName = null) : string
    {
        $tableName = $tableName ?: $this->getEntityTable();
        $fieldList = $fieldList ?: '*';
        if (!\is_array($fieldList)) {
            $query = 'SELECT `' . $tableName . "`.$fieldList FROM `" . $tableName . '`';
        } else {
            foreach ($fieldList as $fieldKey => &$fieldName) {
                $fieldName = '`' . (is_numeric($fieldKey) ? $tableName : $fieldKey) . '`.' . $fieldName;
            }
            $query = 'SELECT ' . implode(', ', $fieldList) . ' FROM `' . $tableName . '`';
        }
        return $query;
    }

    /**
     * @param array $join
     * @param null|string $joinType
     * @return string
     */
    protected function getJoinForQuery(array $join, $joinType = null) : string
    {
        // ajout des jointures
        $query = '';
        foreach ($join as $table => $condition) {
            $query .= " $joinType JOIN `$table` ON $condition";
        }
        return $query;
    }

    /**
     * @param array $order
     * @return string
     */
    protected function getOrderForQuery(array $order = []) : string
    {
        $query = '';
        // ajout de l'ordre
        if (!empty($order)) {
            foreach ($order as $orderCol => &$orderSort) {
                if (!\in_array($orderSort, ['DESC', 'ASC'], true)) {
                    $orderSort = null;
                } else {
                    $orderSort = "$orderCol $orderSort";
                }
            }
            $order = array_filter($order);
            if (!empty($order)) {
                $query .= ' ORDER BY ' . implode(', ', $order);
            }
        }
        return $query;
    }

    /**
     * @param array $where
     * @param array $join
     * @param array $order
     * @param int $page
     * @param int $byPage
     * @return \POM\Service\CursorPdo
     */
    public function fetchCustomQuery(
        array $where = [],
        array $join = [],
        array $order = [],
        $page = -1,
        $byPage = 20
    ) : CursorPdo {
        $query = $this->getSelectForQuery();
        // ajout des jointures
        $query .= $this->getJoinForQuery($join, 'LEFT');
        // ajout des conditions
        if (count($where) === 2 && !empty($where[0])) {
            $query .= ' WHERE ' . $where[0];
        }
        // ajout de l'ordre
        $query .= $this->getOrderForQuery($order);
        // ajoute la limite
        if ($page !== -1) {
            $byPage = max(1, min($byPage, 500));
            $page = max($page, 0);
            $query .= sprintf(
                ' LIMIT %d,%d',
                $page * $byPage,
                $byPage
            );
        }

        return $this->fetchAllQuery($query, !empty($where[1]) ? $where[1] : []);
    }
}
