<?php

namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\Oembed;
use Move\Embed\Parser\ParserInterface;
use PHPUnit\Framework\TestCase;

/**
 * Class DailymotionTest
 * @package Move\Embed\AdapterProvider
 */
class DailymotionTest extends TestCase
{
    /**
     * @return array
     */
    public static function provideStrings()
    {
        $instance = new Dailymotion();
        $parser = $instance->getParser();

        return [
            [$parser, 'https://www.dai.ly/456efg1', true, '456efg1'],
            [$parser, 'www.dai.ly/456efg2', true, '456efg2'],
            [$parser, 'dai.ly/456efg3', true, '456efg3'],
            [$parser, 'dai.ly/video/123abc_#video=456efg4', true, 'video'],

            [$parser, 'https://www.dailymotion.com/embed/video/456efg5', true, '456efg5'],
            [$parser, 'www.dailymotion.com/embed/video/456efg6', true, '456efg6'],
            [$parser, 'dailymotion.com/embed/video/456efg7', true, '456efg7'],
            [$parser, 'dailymotion.com/video/456efg8', true, '456efg8'],
            [$parser, 'dailymotion.com/hub/456efg9', true, '456efg9'],

            [$parser, 'https://www.dailymotion.com/embed/video/123ab10', true, '123ab10'],
            [$parser, 'https://www.dailymotion.com/video/123ab11', true, '123ab11'],
            [$parser, 'https://www.dailymotion.com/hub/123ab12', true, '123ab12'],

            [$parser, 'dailymotion.com/embed/123abc_#video=456efg', false, ''],
            [$parser, 'https://embed/video/123abc_#video=456efg', false, ''],
            [$parser, 'https://www.dailymotion.com/embed/hub/123abc', false, '']
        ];
    }

    /**
     * @covers Dailymotion::getAdapter
     */
    public function testGetAdapter()
    {
        $instance = new Dailymotion();
        $this->assertInstanceOf(
            Oembed::class,
            $instance->getAdapter()
        );
    }

    /**
     * @covers Dailymotion::getParser
     */
    public function testGetParser()
    {
        $instance = new Dailymotion();
        $parser = $instance->getParser();

        $this->assertInstanceOf(
            ParserInterface::class,
            $parser
        );
    }

    /**
     * @dataProvider provideStrings
     * @depends testGetParser
     * @param ParserInterface $parser
     * @param string $str
     * @param string $expectedResult
     * @param string $expectedParam
     */
    public function testGetParserResult(ParserInterface $parser, string $str, $expectedResult, $expectedParam)
    {
        $this->assertEquals($expectedResult, $parser->matchString($str, $param));
        if ($expectedResult) {
            $this->assertEquals($expectedParam, $param[1]);
        }
    }
}
