<?php

namespace Move\Jato\Command;

use PHPUnit\Framework\TestCase;

/**
 * Class AbstractFetchCommandTest
 * @package Move\Jato\Command
 */
class AbstractFetchCommandTest extends TestCase
{
    /**
     * @return AbstractFetchCommand
     */
    public function testConstruct()
    {
        $command = new AbstractFetchCommand();
        $this->assertInstanceOf(AbstractFetchCommand::class, $command);
        return $command;
    }

    /**
     * @depends testConstruct
     * @param AbstractFetchCommand $command
     */
    public function testSetDatabase(AbstractFetchCommand $command)
    {
        $new = 'newDatabase';
        $command->setDatabase($new);
        $result = $command->getDatabase();

        $this->assertEquals($new, $result, 'Not set');
    }

    /**
     * @depends testConstruct
     * @param AbstractFetchCommand $command
     */
    public function testSetExtendedWithHist(AbstractFetchCommand $command)
    {
        $new = 'test';
        $command->setExtendWithHist($new);
        $result = $command->getHistDatabase();

        $this->assertEquals($new, $result, 'Not set');
    }

    /**
     * @depends testConstruct
     * @param AbstractFetchCommand $command
     */
    public function testGetDatabase(AbstractFetchCommand $command)
    {
        $result = $command->getDatabase();
        $this->assertInternalType('string', $result, 'Database not string');
    }

    /**
     * @depends testConstruct
     * @param AbstractFetchCommand $command
     */
    public function testGetHistDatabase(AbstractFetchCommand $command)
    {
        $result = $command->getHistDatabase();
        $this->assertInternalType('string', $result, 'HistDatabase not string');
    }

    /**
     * @depends testConstruct
     * @param AbstractFetchCommand $command
     */
    public function testIsExtendedWithHistTrue(AbstractFetchCommand $command)
    {
        $hist = 'notNull';
        $command->setExtendWithHist($hist);
        $this->assertTrue($command->isExtendWithHist(), 'Not extended with hist');
    }

    /**
     * @depends testConstruct
     * @param AbstractFetchCommand $command
     */
    public function testIsExtendedWithHistFalse(AbstractFetchCommand $command)
    {
        $hist = null;
        $command->setExtendWithHist($hist);
        $this->assertFalse($command->isExtendWithHist(), 'False expected');
    }

}