<?php

namespace Move\Specification;

use Move\Jato\Model\SelectionFilterName;
use PHPUnit\Framework\TestCase;

/**
 * Class EnumSpecificationTest
 * @package Move\Specification
 */
class EnumSpecificationTest extends TestCase
{
    /**
     * test constructor with non enum class
     * @expectedException \InvalidArgumentException
     * @return EnumSpecification
     */
    public function testConstructEnumSpecificationExcepion()
    {
        return new EnumSpecification('DateTime');
    }

    /**
     * @covers EnumSpecification::__construct
     * @return EnumSpecification
     */
    public function testConstructor()
    {
        $enum = new EnumSpecification(SelectionFilterName::class);
        $this->assertInstanceOf(EnumSpecification::class, $enum);
        return $enum;
    }

    /**
     * @covers ArraySpecification::isSatisfiedBy
     * @depends testConstructor
     * @param EnumSpecification $enumSpec
     */
    public function testIsSatisfiedBy(EnumSpecification $enumSpec)
    {
        $satisfied = $enumSpec->isSatisfiedBy(SelectionFilterName::BODY);
        $this->assertTrue($satisfied);

        $notSatisfied = $enumSpec->isSatisfiedBy('XXXX');
        $this->assertFalse($notSatisfied);
    }
}
