<?php


namespace Cms\Bundle\Member;

use Cms\Bundle\Member\Exception\FieldMissingException;
use Cms\Bundle\Member\Exception\PasswordFailedException;

/**
 * Trait MemberPasswordTrait
 * @package Cms\Bundle\Member
 */
trait MemberPasswordTrait
{

    /**
     * @param string $password
     * @return bool
     */
    abstract protected function checkPassword(string $password) : bool;

    /**
     * @param array $dataset
     * @param string $key1
     * @param string $key2
     * @param bool $mandatory
     * @throws \Cms\Bundle\Member\Exception\PasswordFailedException
     * @throws \Cms\Bundle\Member\Exception\FieldMissingException
     */
    protected function validatePassword(
        array $dataset,
        string $key1 = 'password',
        string $key2 = 'confirm_password',
        bool $mandatory = true
    ) {
        if (!isset($dataset[$key1], $dataset[$key2])) {
            if ($mandatory) {
                throw new FieldMissingException(
                    !isset($dataset[$key1]) ? $key1 : $key2
                );
            }
        } else {
            if (empty($dataset[$key1]) && empty($dataset[$key2])) {
                if ($mandatory) {
                    throw new PasswordFailedException(
                        MemberErrorCode::PASSWORD_FAILED_EQUAL
                    );
                }
            } else {
                // on check si les deux mots de passe concordent
                if ($dataset[$key1] !== $dataset[$key2]) {
                    throw new PasswordFailedException(
                        MemberErrorCode::PASSWORD_FAILED_EQUAL
                    );
                }

                // on check la validité du mot de passe
                if (!$this->checkPassword($dataset[$key1])) {
                    throw new PasswordFailedException(
                        MemberErrorCode::PASSWORD_FAILED_POLICY
                    );
                }
            }
        }
    }
}
