<?php

namespace Cms\Client\AddressBook;

use Cms\Client\ClientIndexQueryBuilder;
use Cms\Model\AddressBook\Trip\TripState;
use Cms\Model\AddressBook\Trip\TripType;
use Cms\Model\AddressBook\Trip\TripVisibility;

/**
 * Class AddressBookTripClientQueryBuilder
 * @package Cms\Client\AddressBook
 */
class AddressBookTripClientQueryBuilder extends ClientIndexQueryBuilder
{

    /**
     * @param int|array $categoryId
     * @return $this
     */
    public function setCategoryId($categoryId)
    {
        return $this->setFilter('category_id', $categoryId);
    }

    /**
     * @param string $search
     * @return $this
     */
    public function setSearch($search)
    {
        return $this->setFilter('search', $search);
    }

    /**
     * @param int $scope
     * @return $this
     */
    public function setScope($scope)
    {
        return $this->setFilter('scope_id', $scope);
    }

    /**
     * @param string|TripType $type
     * @return $this
     */
    public function setType($type)
    {
        return $this->setFilter('type', (string)$type);
    }

    /**
     * @param string|TripState $state
     * @return $this
     */
    public function setState($state)
    {
        return $this->setFilter('state', (string)$state);
    }

    /**
     * @param string|TripVisibility $visibility
     * @return $this
     */
    public function setVisility($visibility)
    {
        return $this->setFilter('visibility', (string)$visibility);
    }

    /**
     * @param string $countryCode
     * @return $this
     */
    public function setExcludeStepCountry($countryCode)
    {
        return $this->setFilter('exclude_step_country', (string)$countryCode);
    }

    /**
     * @param string $adminCode
     * @param int $level
     * @return $this
     */
    public function setStepAdminCode($adminCode, $level)
    {
        return $this->setFilter('step_admin' . $level . '_code', (string)$adminCode);
    }

    /**
     * @param string $countryCode
     * @return $this
     */
    public function setStepCountry($countryCode)
    {
        return $this->setFilter('step_country', (string)$countryCode);
    }

    /**
     * @param int $rank
     * @return $this
     */
    public function setStepRank(int $rank)
    {
        return $this->setFilter('step_rank', $rank);
    }

    /**
     * @param float $fromDistance
     * @param float|null $toDistance
     * @return $this
     */
    public function setDistance($fromDistance, $toDistance = null)
    {
        return $this
            ->setFilter('from_distance', $fromDistance)
            ->setFilter('to_distance', $toDistance);
    }

    /**
     * @param $showCmsUserOnly
     * @return $this
     */
    public function showCmsUserOnly($showCmsUserOnly = true)
    {
        return $this->setFilter('show_cms_user_only', (bool)$showCmsUserOnly);
    }

    /**
     * @param bool $showAuthorOnly
     * @return $this
     */
    public function showAuthorOnly($showAuthorOnly = true)
    {
        return $this->setFilter('show_author_only', (bool)$showAuthorOnly);
    }

    /**
     * @param $authorId
     * @return $this
     */
    public function setAuthor($authorId)
    {
        return $this->setFilter('author_id', $authorId);
    }
}
