<?php


namespace Cms\Client\AddressBook;

use Cms\Model\AddressBook\Contact\ContactModel;
use Cms\Model\AddressBook\Contact\ContactType;

/**
 * Class ContactAwareModelTrait
 * @package Cms\Client\AddressBook
 * @property \Cms\Model\AddressBook\Contact\ContactModel[] $contacts
 */
trait ContactAwareModelTrait
{

    /** @var  \Cms\Model\AddressBook\Contact\ContactModel[] */
    protected $contacts;

    /**
     * @param ContactModel $contact
     * @return $this
     */
    public function addContact(ContactModel $contact)
    {
        // ajoute le contact s'il n'existe pas
        foreach ($this->getContactsByType($contact->type) as $item) {
            if ($item->value === $contact->value) {
                return $this;
            }
        }
        $this->contacts[] = $contact;
        return $this;
    }

    /**
     * @param string|ContactType $contactType
     * @return \Cms\Model\AddressBook\Contact\ContactModel[]
     */
    public function getContactsByType($contactType)
    {
        $contacts = [];
        foreach ($this->contacts ?: [] as $contact) {
            if ((string)$contact->type === (string)$contactType) {
                $contacts[] = $contact;
            }
        }
        return $contacts;
    }
}
