<?php


namespace Cms\Client\Command\Article\Command;

use Cms\Client\Command\ScopeFilterAwareInterface;
use Cms\Client\Command\ScopeFilterAwareTrait;
use Cms\Model\Article\Category\CategoryProfil;

/**
 * Class FetchAllRubriqueCommand
 * @package AutoMag\Command\Rubrique\Command
 */
class FetchAllArticleCategoryByFilterCommand implements ScopeFilterAwareInterface
{
    use ScopeFilterAwareTrait;

    /** @var  int */
    protected $parentId;

    /** @var  string|CategoryProfil */
    protected $profil;


    /**
     * @return int
     */
    public function getParentId()
    {
        return $this->parentId;
    }

    /**
     * @param int $parentId
     * @return FetchAllArticleCategoryByFilterCommand
     */
    public function setParentId($parentId)
    {
        $this->parentId = $parentId;
        return $this;
    }

    /**
     * @return CategoryProfil|string
     */
    public function getProfil()
    {
        return $this->profil;
    }

    /**
     * @param CategoryProfil|string $profil
     * @return FetchAllArticleCategoryByFilterCommand
     */
    public function setProfil($profil)
    {
        $this->profil = $profil;
        return $this;
    }
}
