<?php

namespace Cms\Client\Service;

use Cms\Client\CmsHttpClientInterface;
use Cms\Client\Member\MemberRewardClient;
use League\Container\ServiceProvider\AbstractServiceProvider;

/**
 * Class MemberRewardProvider
 * @package Cms\Client\Service
 */
class MemberRewardProvider extends AbstractServiceProvider
{
    /** @var array */
    protected $provides = [
        MemberRewardService::class,
        MemberRewardClient::class,
    ];

    /**
     * Use the register method to register items with the container via the
     * protected $this->container property or the `getContainer` method
     * from the ContainerAwareTrait.
     * @return void
     */public function register()
    {
        // add clients
        $this->container->add(MemberRewardClient::class)
            ->withArgument(CmsHttpClientInterface::class);

        // add services
        $this->container->add(MemberRewardService::class)
            ->withArguments([
                MemberRewardClient::class,
            ]);
    }
}
