<?php


namespace Cms\LinkResource\Provider\CMS;

use Cms\LinkResource\LinkResourceType;
use Cms\LinkResource\Provider\AbstractDelegateDataAdapter;
use Cms\Model\Article\ArticleModel;
use Cms\Model\Article\Category\CategoryModel;
use POM\DomainObjectInterface;

/**
 * Class AbstractCmsArticleProvider
 * @package Cms\LinkResource\Provider\CMS
 */
abstract class AbstractCmsArticleProvider extends AbstractDelegateDataAdapter implements
    CmsProviderScopeAwareInterface
{
    use CmsProviderScopeAwareTrait;

    /** @var array */
    protected $types = [
        LinkResourceType::ARTICLE,
        LinkResourceType::ARTICLE_CATEGORY,
        LinkResourceType::GALLERY,
    ];

    /**
     * @inheritdoc
     */
    public function getLabelFromModel(DomainObjectInterface $model)
    {
        if ($model instanceof ArticleModel) {
            return ($model->short_title ? $model->short_title . ' - ' : '') . $model->title;
        }
        if ($model instanceof CategoryModel) {
            return $model->name;
        }
        return null;
    }
}
