<?php

namespace Cms\LinkResource\Provider\CMS;

use Cms\Client\Member\MemberClient;
use Cms\Client\Service\MemberService;
use Cms\LinkResource\LinkResourceModel;
use Cms\LinkResource\LinkResourceType;
use Cms\LinkResource\Provider\ProviderClientAdapterInterface;
use Cms\LinkResource\Provider\ProviderRestfulClientAdapter;
use Cms\LinkResource\Provider\SearchAdapterAwareInterface;
use Cms\LinkResource\Provider\SearchAdapterAwareTrait;

/**
 * Class CmsMemberProvider
 * @package Cms\LinkResource\Provider\CMS
 */
class CmsMemberProvider extends AbstractCmsMemberProvider implements
    SearchAdapterAwareInterface
{
    use SearchAdapterAwareTrait;

    /**
     * @var MemberService
     */
    private $memberService;

    /**
     * CmsMemberProvider constructor.
     * @param MemberService $memberService
     */
    public function __construct(MemberService $memberService)
    {
        $this->memberService = $memberService;
    }

    /**
     * @param LinkResourceType|string $typeCode
     * @return MemberClient|null
     */
    protected function getClientByTypeCode($typeCode)
    {
        switch ((string)$typeCode) {
            case LinkResourceType::MEMBER:
                return $this->memberService->getMemberClient();
                break;
        }
        return null;
    }

    /**
     * @param mixed $typeCode
     * @return \Cms\LinkResource\Provider\ProviderClientAdapterInterface
     * @throws \RuntimeException
     */
    protected function getClientAdapter($typeCode) : ProviderClientAdapterInterface
    {
        $client = $this->getClientByTypeCode($typeCode);
        if ($client !== null) {
            return new ProviderRestfulClientAdapter($client);
        }
        throw new \RuntimeException('no client adapter');
    }

    /**
     * @param LinkResourceType|string $typeCode
     * @param mixed $query
     * @return LinkResourceModel[]
     */
    public function execSearch($typeCode, $query)
    {
        if (is_numeric($query)) {
            $resource = $this->getData($typeCode, $query);
            if ($resource) {
                return [
                    $resource->id,
                ];
            }
        }
        switch ((string)$typeCode) {
            case LinkResourceType::MEMBER:
                $results = $this->getClientByTypeCode($typeCode)->getIndexBySearch($query);
                if (empty($results)) {
                    return [];
                }
                // On récupère les id de chaque modele pour les renvoyer
                $results = iterator_to_array($results);
                foreach ($results as &$model) {
                    $model = $model->id;
                }
                return $results;
                break;
        }
        return [];
    }
}
