<?php

namespace Cms\Model\Campsite\Product;

use Cms\Model\AbstractModelCollection;
use POM\DomainObjectInterface;

/**
 * Class ProductI18nCollection
 * @package Cms\Model\Campsite\Product
 */
class ProductI18nCollection extends AbstractModelCollection
{

    /**
     * ProductI18nCollection constructor.
     * @param array|null $models
     */
    public function __construct(array $models = null)
    {
        foreach ($models as $model) {
            if (\is_array($model)) {
                $this->addItem($model);
            }
        }
    }

    /**
     * @param array $modelData
     * @return \POM\DomainObjectInterface
     */
    public function handleModel(array $modelData) : DomainObjectInterface
    {
        return (new ProductI18nModel())->populate($modelData, true);
    }
}
