<?php

namespace Cms\Model\Contract\Product;

use Cms\Model\ConfigAwareModelTrait;
use Cms\Model\I18nModelInterface;
use Cms\Model\I18nModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class ProductConfigI18nModel
 * @package Cms\Model\Contract\Product
 * @property int $config_id
 */
class ProductConfigI18nModel extends DomainObjectAbstract implements I18nModelInterface
{
    use I18nModelTrait;
    use ConfigAwareModelTrait;

    /**
     * @relation
     * @var int
     */
    protected $config_id;

    /**
     * @param string $offset
     * @return mixed
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \InvalidArgumentException
     */
    public function propertyGet($offset)
    {
        if ($offset === 'config') {
            return $this->getConfig();
        }
        return parent::propertyGet($offset);
    }
}
