<?php


namespace Cms\Serializer;

use Cms\DashParser\Serializer\HtmlEntityDocumentConverter;
use Cms\DashParser\Serializer\HtmlEntityEmbedConverter;
use Cms\DashParser\Serializer\HtmlEntityImageConverter;
use Cms\DashParser\Serializer\HtmlEntityLinkConverter;
use Cms\DashParser\Serializer\HtmlEntityResourceConverter;
use Move\Embed\EmbedMapper;

/**
 * Class HtmlEntityConverter
 * @package Cms\Serializer
 */
class HtmlEntityConverter extends \Cms\DashParser\Serializer\HtmlEntityConverter
{

    /**
     * HtmlEntityConverter constructor.
     * @param EmbedMapper $embedMapper
     * @param HtmlEntityImageConverter $imageConverter
     * @param HtmlEntityEmbedConverter $embedConverter
     * @param HtmlEntityLinkConverter $linkConverter
     * @param HtmlEntityResourceConverter $resourceConverter
     * @param HtmlEntityDocumentConverter|null $documentConverter
     */
    public function __construct(
        EmbedMapper $embedMapper,
        HtmlEntityImageConverter $imageConverter = null,
        HtmlEntityEmbedConverter $embedConverter = null,
        HtmlEntityLinkConverter $linkConverter = null,
        HtmlEntityResourceConverter $resourceConverter = null,
        HtmlEntityDocumentConverter $documentConverter = null
    ) {
        parent::__construct(
            $imageConverter ?: new \Cms\Serializer\HtmlEntityImageConverter(),
            $embedConverter ?: new \Cms\Serializer\HtmlEntityEmbedConverter($embedMapper),
            $linkConverter,
            $resourceConverter,
            $documentConverter ?: new \Cms\Serializer\HtmlEntityDocumentConverter()
        );
    }

    /**
     * @param int|null $mediaMaxWidth
     * @return $this
     */
    public function setMediaMaxWidth($mediaMaxWidth)
    {
        if ($this->imageConverter instanceof \Cms\Serializer\HtmlEntityImageConverter) {
            $this->imageConverter->setMediaMaxWidth($mediaMaxWidth);
        }
        return $this;
    }
}
