<?php

namespace Move\Command\Command;

/**
 * Class FetchAllCommand
 * @package Move\Command\Command
 */
class FetchAllCommand implements
    FilterCommandInterface,
    SortCommandInterface
{
    use FilterCommandTrait;
    use SortCommandTrait;

    /**
     * FetchAllCommand constructor.
     * @param array $sortCols
     * @param array $filters
     * @throws \InvalidArgumentException
     */
    public function __construct($sortCols = [], $filters = [])
    {
        if (!empty($sortCols) && !\is_array($sortCols)) {
            throw new \InvalidArgumentException('sortCols must be an array');
        }
        if (!empty($filters) && !\is_array($filters)) {
            throw new \InvalidArgumentException('filters must be an array');
        }
        $this->sortCols = $sortCols ?: [];
        $this->filters = $filters ?: [];
    }
}
