<?php

namespace Move\Embed;

/**
 * Class Model
 * @package Embed
 */
class EmbedModel
{

    /**
     * @var string
     */
    public $title;

    /**
     * @var string
     */
    public $provider_name;

    /**
     * @var string
     */
    public $provider_url;

    /**
     * @var int
     */
    public $cache_age;

    /**
     * @var string
     */
    public $thumbnail_url;

    /**
     * @var int
     */
    public $thumbnail_width;

    /**
     * @var int
     */
    public $thumbnail_height;

    /**
     * @var string
     */
    public $canonical_url;

    /**
     * @var string
     */
    public $author_url;

    /**
     * @var string
     */
    public $author_name;

    /**
     * @var string
     */
    public $html;

    /**
     * @var mixed
     */
    public $provider_data;

    /**
     * @var string
     */
    public $source_url;


    /**
     * @param array $data
     * @param array $originalData
     * @throws \ReflectionException
     */
    public function __construct(array $data = [], $originalData = null)
    {
        // application des parametre
        foreach ((new \ReflectionClass($this))->getProperties(\ReflectionProperty::IS_PUBLIC) as $property) {
            if (!empty($data[$property->getName()])) {
                $property->setValue($this, $data[$property->getName()]);
            }
        }
        // insert des données
        $this->provider_data = $originalData ?: $data;
    }

    /**
     * @return array
     */
    final public function getArrayCopy()
    {
        $d = $this;
        $publics = function () use ($d) {
            return get_object_vars($d);
        };
        return $publics();
    }
}
