<?php

namespace Move\Template\Html\Asset;

/**
 * Class Scripts
 * @package Html\Asset
 */
class Scripts implements AssetInterface
{

    /** @var  string */
    private static $VERSION;

    /**
     * @var bool
     */
    protected $async;

    /**
     * @var string
     */
    protected $src;

    /**
     * @var null|string
     */
    protected $condition;


    /**
     * @param string $src
     * @param string|null $condition condition IE, de la forme 'lte IE 8'
     * @param bool $async
     */
    public function __construct($src, $condition = null, $async = false)
    {
        $this->src = $src;
        $this->condition = $condition;
        $this->async = $async;
    }

    /**
     * @inheritdoc
     */
    public function __toString()
    {
        return $this->render();
    }

    /**
     * @{@inheritdoc}
     */
    public function render()
    {
        $src = $this->src;
        if (!empty(self::$VERSION)) {
            $src .= (strpos($this->src, '?') ? '&' : '?') . 'v=' . self::$VERSION;
        }
        $source = '<script ' . ($this->async === true ? 'async ' : '') . 'src="' . $src . '"></script>';
        if ($this->condition) {
            $source = '<!--[if ' . $this->condition . ']>' . $source . '<![endif]-->';
        }
        return $source;
    }

    /**
     * Renvoi la copie sous forme de tableau de la metadata
     * @return array
     */
    public function getArrayCopy()
    {
        return [
            'src' => $this->src,
            'async' => $this->async,
            'condition' => $this->condition,
        ];
    }

    /**
     * @param string $version
     */
    public static function setVersionNumber($version)
    {
        self::$VERSION = $version;
    }
}
