<?php

namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\OembedFacebook;
use Move\Embed\Parser\ParserInterface;
use PHPUnit\Framework\TestCase;

/**
 * Class FacebookVideoTest
 * @package Move\Embed\AdapterProvider
 */
class FacebookVideoTest extends TestCase
{
    /**
     * @return array
     */
    public function provideStrings()
    {
        $instance = new FacebookVideo();
        $parser = $instance->getParser();

        return [
            [$parser, 'https://www.facebook.com/123.abc/videos/45/', true, '45'],
            [$parser, 'http://www.facebook.com/123.abc/videos/450/', true, '450'],
            [$parser, 'www.facebook.com/123abc/videos/46/', true, '46'],
            [$parser, 'facebook.com/123abc/videos/47/', true, '47'],

            [$parser, 'https://www.facebook.com/video.php?v=48/', true, '48'],
            [$parser, 'http://www.facebook.com/video.php?v=480/', true, '480'],
            [$parser, 'www.facebook.com/video.php?v=49/', true, '49'],
            [$parser, 'facebook.com/video.php?v=50/', true, '50'],

            [$parser, 'facebook.com/videos.php?v=50/', false],
            [$parser, 'facebook.com/videos/50/', false],
        ];
    }

    /**
     * @covers FacebookVideo::getAdapter
     */
    public function testGetAdapter()
    {
        $instance = new FacebookVideo();
        $adapter = $instance->getAdapter();
        $this->assertInstanceOf(OembedFacebook::class, $adapter);
    }

    /**
     * @covers FacebookVideo::getParser
     */
    public function testGetParser()
    {
        $instance = new FacebookVideo();
        $this->assertInstanceOf(
            ParserInterface::class,
            $instance->getParser()
        );
    }

    /**
     * @dataProvider provideStrings
     * @depends testGetParser
     * @param ParserInterface $parser
     * @param string $str
     * @param $expectedResult
     * @param $expectedParam
     */
    public function testGetParserResult(ParserInterface $parser, string $str, $expectedResult, $expectedParam)
    {
        $this->assertEquals($expectedResult, $parser->matchString($str, $param));
        if ($expectedResult) {
            $this->assertEquals($expectedParam, $param[1]);
        }
    }
}
