<?php


namespace Cms\Client\Geodata;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Client\Geodata\Model\CityRestfulModel;
use Cms\Client\Geodata\Model\PoiRestfulModel;
use GuzzleHttp\Psr7\Request;

class PoiClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'geodata/poi';

    /**
     * @param array $dataset
     * @return PoiRestfulModel
     */
    public function handleData($dataset = [])
    {
        return (new PoiRestfulModel())->populate($dataset);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|CityRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }

    /**
     * @param string $inseeCode
     * @param string $category
     * @param int|null $limit
     * @return \Cms\Client\CmsApiIndexIterator|\Cms\Client\Geodata\Model\CityRestfulModel[]
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpServerException
     */
    public function searchCloseToByInseeCode(string $inseeCode, string $category, int $limit = null)
    {
        $uri = sprintf(
            '%s/proximity/%s/%s%s',
            $this->basePath,
            $category,
            $inseeCode,
            $limit ? '?limit=' . $limit : ''
        );

        return $this->request('GET', [$uri]);
    }
}
