<?php


namespace Cms\LinkResource;

use Cms\LinkResource\Provider\CMS\CmsProvider;

/**
 * Class LinkResourceFactory
 * @package Cms\LinkResource
 */
class LinkResourceFactory
{

    /**
     * @param string|\Cms\LinkResource\LinkResourceType $type
     * @param mixed $ref
     * @param null|string $provider
     * @return string
     * @throws \InvalidArgumentException
     */
    public static function createUrn($type, $ref, string $provider = null) : string
    {
        $model = static::createResource($type, $ref, $provider);
        return $model->toUrn();
    }

    /**
     * @param string|\Cms\LinkResource\LinkResourceType $type
     * @param mixed $ref
     * @param null|string $provider
     * @return \Cms\LinkResource\LinkResourceModel
     * @throws \InvalidArgumentException
     */
    public static function createResource($type, $ref, string $provider = null) : LinkResourceModel
    {
        if (!LinkResourceType::isValid((string)$type)) {
            throw new \InvalidArgumentException('link type is invalid ' . $type);
        }
        $model = (new LinkResourceModel())->populate([
            'link_type' => $type,
            'link_ref' => $ref,
            'link_provider' => $provider ?: CmsProvider::IDENTIFIER,
        ]);
        return $model;
    }

    /**
     * @param string $urn
     * @return \Cms\LinkResource\LinkResourceModel|null
     * @throws \InvalidArgumentException
     */
    public static function createFromUrn(string $urn)
    {
        $parts = explode(':', $urn);
        array_shift($parts);
        if (array_shift($parts) === 'move' && count($parts) >= 3) {
            return static::createResource($parts[1], $parts[2], $parts[0]);
        }
        return null;
    }
}
