<?php


namespace Cms\Model\Campsite;

/**
 * Class CampsitePriceModelTrait
 * @package Cms\Model\Campsite
 * @property int $campsite_id
 * @property int $season_year
 * @property CampsiteSeasonPeriod $season_period
 * @property string $amount
 * @property string $duration
 * @property CampsitePriceDurationType $duration_type
 * @property bool $is_free
 */
trait CampsitePriceModelTrait
{
    /** @var  int */
    protected $campsite_id;

    /** @var  int */
    protected $season_year;

    /** @var  CampsiteSeasonPeriod */
    protected $season_period;

    /** @var  string */
    protected $amount;

    /** @var  string */
    protected $duration;

    /** @var  CampsitePriceDurationType */
    protected $duration_type;

    /** @var  bool */
    protected $is_free;

    /**
     * @param $name
     * @param $value
     */
    public function propertySet($name, $value)
    {
        if ($name === 'amount') {
            $value = str_replace(',', '.', $value);
        }
        parent::propertySet($name, $value);
    }
}
