<?php


namespace Cms\Model\Member;

use Cms\Model\CmsUserIdAwareTrait;
use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class MemberModel
 * @package Cms\Model\Member
 * @property int $id
 * @property string $import_ref
 * @property string $email
 * @property string $gender
 * @property string $firstname
 * @property string $lastname
 */
class MemberModel extends DomainObjectAbstract
{
    use StampAwareModelTrait;
    use CmsUserIdAwareTrait;

    /** @var  int */
    protected $id;

    /** @var  string */
    protected $import_ref;

    /** @var  string */
    protected $email;

    /** @var  MemberGender */
    protected $gender;

    /** @var  string */
    protected $firstname;

    /** @var  string */
    protected $lastname;

    /**
     * @param string $name
     * @param mixed $value
     */
    public function propertySet($name, $value)
    {
        switch ($name) {
            case 'email':
                $value = mb_strtolower($value);
                break;
        }
        parent::propertySet($name, $value);
    }
}
