<?php


namespace Cms\Transformer\Decorator;

/**
 * Class AbstractTransformerDecorator
 * @package CampingFrance\Front\Transformer\Decorator
 */
abstract class AbstractTransformerDecorator
{

    /** @var TransformerDecoratorInterface[] */
    private $decorators = [];

    /**
     * @param \Cms\Transformer\Decorator\TransformerDecoratorInterface $decorator
     * @return $this
     */
    public function addDecorator(TransformerDecoratorInterface $decorator)
    {
        $this->decorators[] = $decorator;
        return $this;
    }

    /**
     * @param mixed $element
     * @param array $dataset
     * @return array
     */
    protected function decorate($element, array $dataset) : array
    {
        foreach ($this->decorators as $decorator) {
            $callback = $decorator->getDatasetDecorator($element);
            $callbackResult = $callback($dataset);
            if ($callbackResult === null) {
                break;
            }
            if (\is_array($callbackResult)) {
                $dataset = $callbackResult;
            }
        }
        return $dataset;
    }

    /**
     * @param mixed $object
     * @return array
     */
    final public function __invoke($object) : array
    {
        return $this->transform($object);
    }

    /**
     * @param mixed $object
     * @return array
     */
    final public function transform($object) : array
    {
        $dataset = $this->transformToArray($object);
        // decoration du dataset
        $dataset = $this->decorate($object, $dataset);
        return $dataset;
    }

    /**
     * @param mixed $object
     * @return array
     */
    abstract public function transformToArray($object) : array;
}
