<?php


namespace Move\Embed\AdapterProvider;

use Move\Embed\Adapter\OembedFacebook;
use Move\Embed\Parser\MultiRegexParser;

/**
 * Class Facebook
 * @package Move\Embed\AdapterProvider
 */
class FacebookVideo extends AbstractAdapterProvider
{

    /**
     * @return OembedFacebook
     */
    public function getAdapter()
    {
        return new OembedFacebook('https://www.facebook.com/plugins/video/oembed.json/', [
            'omitscript' => true,
        ], $this->getParser());
    }

    /**
     * @return MultiRegexParser
     */
    public function getParser()
    {
        return new MultiRegexParser([
            '@^(?:https?://)?(?:www\.)?facebook\.com/(?:[a-zA-Z0-9-\.]+/)?videos/([0-9]+)/@',
            '@^(?:https?://)?(?:www\.)?facebook\.com/video.php?(?:v|id)=([0-9]+)/@',
        ]);
    }
}
