<?php


namespace Move\Embed;

use Move\Cache\CacheAwareInterface;
use Move\Cache\CacheAwareTrait;
use Move\Embed\Adapter\AdapterInterface;
use Move\Embed\AdapterProvider\AdapterProviderInterface;
use Move\Utils\Str;

/**
 * Class EmbedMapper
 * @package Move\Embed
 */
class EmbedMapper implements CacheAwareInterface
{
    use CacheAwareTrait;

    /** @var AdapterProviderInterface */
    private $provider;

    /**
     * EmbedMapper constructor.
     * @param AdapterProviderInterface $provider
     */
    public function __construct(AdapterProviderInterface $provider)
    {
        $this->provider = $provider;
    }

    /**
     * @param string $sourceUri
     * @return EmbedModel|null
     * @throws \Exception
     * @throws \Psr\Cache\InvalidArgumentException
     * @throws \UnexpectedValueException
     */
    public function fetchModel($sourceUri)
    {
        $cacheKey = 'SaveEmbedModel^1.0^' . Str::toAscii($sourceUri);
        $cachePool = $this->getItemCachePool();
        if ($cachePool !== null) {
            $cacheItem = $cachePool->getItem($cacheKey);
            if ($cacheItem->isHit()) {
                return $cacheItem->get();
            }
        }
        $adapter = $this->getAdapter($sourceUri);
        $result = $adapter->getEmbedModel($sourceUri);
        if ($cachePool !== null) {
            $cacheItem = $cachePool->getItem($cacheKey)
                ->expiresAfter(new \DateInterval('P1D'))
                ->set($result);
            $cachePool->save($cacheItem);
        }
        return $result;
    }

    /**
     * @param string $sourceUri
     * @return AdapterInterface
     * @throws \UnexpectedValueException
     */
    public function getAdapter($sourceUri) : Adapter\AdapterInterface
    {
        $adapter = $this->provider->handle($sourceUri);
        if (!$adapter instanceof AdapterInterface) {
            throw new \UnexpectedValueException("no adapter for $sourceUri");
        }
        return $adapter;
    }
}
