<?php

namespace Move\Template\Html;

use Move\Utils\TaggedItemCollection;

/**
 * Class RenderByTagStrategy
 * @package Move\Template\Html
 */
class RenderByTagStrategy extends RenderAllStrategy
{

    /**
     * Effectue le rendu d'une collection en suivant une strategie prédéfini
     * @param TaggedItemCollection $itemCollection
     * @param array $tags
     * @return string
     */
    public function render(TaggedItemCollection $itemCollection, array $tags)
    {
        // si aucun tag on renvoi la liste complete
        if (empty($tags)) {
            return parent::render($itemCollection, $tags);
        }

        // effectue un rendu des asset taggé
        $itemRendered = array_map(function ($item) {
            return (string)$item;
        }, $itemCollection->getByTags($tags));

        return implode($this->getGlue(), $itemRendered);
    }
}
