<?php


namespace Cms\Client\Article;

use Cms\Client\AbstractClient;
use Cms\Client\Article\Model\ContainerRestfulModel;
use Cms\Client\CmsApiIndexIterator;

/**
 * Class ContainerClient
 * @package Cms\Client\Article
 */
class ContainerClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'article/container';

    /**
     * @param array $dataset
     * @return \Cms\Client\Article\Model\ContainerRestfulModel
     */
    public function handleData($dataset = []) : ContainerRestfulModel
    {
        return (new ContainerRestfulModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|ContainerRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }
}
