<?php

namespace Cms\Client\Service;

/**
 * Trait MemberRewardServiceAwareTrait
 * @package Cms\Client\Service
 */
trait MemberRewardServiceAwareTrait
{
    /** @var  \Cms\Client\Service\MemberRewardService */
    protected $memberRewardService;

    /**
     * @param \Cms\Client\Service\MemberRewardService $memberRewardService
     * @return $this
     */
    public function setMemberRewardService(MemberRewardService $memberRewardService)
    {
        $this->memberRewardService = $memberRewardService;
        return $this;
    }

    /**
     * @return \Cms\Client\Service\MemberRewardService
     * @throws \DomainException
     */
    public function getMemberRewardService() : MemberRewardService
    {
        if (!$this->memberRewardService instanceof MemberRewardService) {
            throw new \DomainException('memberRewardService is not a MemberRewardService instance');
        }
        return $this->memberRewardService;
    }
}
