<?php


namespace Cms\Model\AddressBook\Contact;

use Cms\Model\StampAwareModelTrait;
use POM\DomainObjectAbstract;

/**
 * Class ContactModel
 * @package Cms\Model\AddressBook\Contact
 * @property int $id
 * @property int $addressbook_id
 * @property int $address_id
 * @property string $name
 * @property string $description
 * @property string $value
 * @property ContactType $type
 */
class ContactModel extends DomainObjectAbstract
{
    use StampAwareModelTrait;

    /** @var  int */
    protected $id;

    /** @var  int */
    protected $address_id;

    /** @var  string */
    protected $name;

    /** @var  string */
    protected $description;

    /** @var  string */
    protected $value;

    /** @var  ContactType */
    protected $type;
}
