<?php


namespace Cms\Search\Mapping;

use Cms\Model\AddressBook\Address\AddressModel;

/**
 * Class AddressDocumentTrait
 * @package Cms\Search\Mapping
 */
trait AddressDocumentTrait
{
    /**
     * @param string $linktType
     * @param \Cms\Model\AddressBook\Address\AddressModel $addressModel
     * @return array
     */
    private static function buildAddressMapping(
        string $linktType,
        AddressModel $addressModel
    ) : array {
        return [
            'id' => $addressModel->id,
            'city_name' => $addressModel->city_name,
            'city_name_fre' => $addressModel->country_alpha2 === 'FR' ? $addressModel->city_name : null,
            'admin1_code' => $addressModel->admin1_code,
            'admin2_code' => $addressModel->admin2_code,
            'address1' => $addressModel->address1,
            'address2' => $addressModel->address2,
            'country_code' => $addressModel->country_alpha2,
            'postal_code' => $addressModel->postal_code,
            'type' => $linktType,
            'city_osm_id' => $addressModel->city_osm_id,
            'city_geodata_id' => $addressModel->city_geodata_id,
            'geo_location' => $addressModel->is_geocoded
            && $addressModel->gps_location
            && $addressModel->gps_location->latitude
            && $addressModel->gps_location->longitude ? [
                'lat' => (float)$addressModel->gps_location->latitude,
                'lon' => (float)$addressModel->gps_location->longitude,
            ] : null,
        ];
    }
}
