<?php


namespace Move\Image\Tools;

/**
 * Class JpegTran
 * @package Move\Image\Tools
 */
class JpegTran
{
    /** @var  string */
    private $binaryPath;

    /**
     * JpegTran constructor.
     * @param string $binaryPath
     */
    public function __construct($binaryPath = '/usr/bin/jpegtran')
    {
        $this->binaryPath = $binaryPath;
    }

    /**
     * @param string $imagePath
     * @return $this
     * @throws \RuntimeException
     */
    public function optimise($imagePath)
    {
        exec(
            $this->binaryPath . ' -copy none -opt -progressive -outfile ' . $imagePath . ' ' . $imagePath,
            $outputs,
            $resultVar
        );
        if ($resultVar != 0) {
            throw new \RuntimeException('JPEGTRAN was unable to optimise image, result:' . $resultVar . ' File: ' . $imagePath);
        }
        return $this;
    }
}
