<?php

namespace Move\Log;

use Monolog\Logger;
use Move\Environment;
use Rollbar\Rollbar;

/**
 * Class RollbarHandlerFactory
 * @package Move\Log
 */
class RollbarHandlerFactory
{

    /**
     * @param string $accessToken
     * @param string|null $rootPath
     * @param Environment $env
     * @param int|null $logLevel
     * @return MonologRollbarHandler
     */
    public static function create(
        string $accessToken,
        string $rootPath,
        Environment $env = null,
        $logLevel = null
    ) : MonologRollbarHandler {
        $env = $env ?: new Environment();

        // installs global error and exception handlers
        $config = [
            // required
            'access_token' => $accessToken,
            // optional - environment name. any string will do.
            'environment' => $env->getTypeName(),
            // optional - path to directory your code is in. used for linking stack traces.
            'root' => $rootPath,
        ];

        // installs global error and exception handlers
        Rollbar::init($config, false, false, false);
        $rollbarHandler = new MonologRollbarHandler(
            Rollbar::logger(),
            $logLevel ?: Logger::ERROR
        );

        return $rollbarHandler;
    }
}
