<?php
/**
 * Created by PhpStorm.
 * User: MOVE-02
 * Date: 10/5/2017
 * Time: 5:27 PM
 */

namespace Move\Embed;

use PHPUnit\Framework\TestCase;

/**
 * Class EmbedModelTest
 * @package Move\Embed
 */
class EmbedModelTest extends TestCase
{
    protected $data = [
        'title' => 'Dummy title',
        'html' => '<p>Dummy html</p>'
    ];

    /**
     * @covers EmbedModel::__construct
     * @return EmbedModel
     */
    public function testConstruct()
    {
        $model = new EmbedModel($this->data);

        $this->assertEquals($this->data['title'], $model->title);
        $this->assertEquals($this->data['html'], $model->html);
        $this->assertEquals(null, $model->author_url);

        $this->assertEquals($this->data, $model->provider_data);

        return $model;
    }

    /**
     * @param EmbedModel $model
     * @depends testConstruct
     */
    public function testGetArrayCopy(EmbedModel $model)
    {
        $data = $model->getArrayCopy();

        $expected =  [
            'title' => null,
            'html' => null,
            'provider_name' => null,
            'provider_url' => null,
            'cache_age' => null,
            'thumbnail_url' => null,
            'thumbnail_width' => null,
            'thumbnail_height' => null,
            'canonical_url' => null,
            'author_url' => null,
            'author_name' => null,
            'source_url' => null
        ];

        $expected = array_merge($expected, $this->data);
        $expected['provider_data'] = $this->data;

        $this->assertEquals($expected, $data);
    }


}
