<?php

namespace Move\Http\Client;

use PHPUnit\Framework\TestCase;

/**
 * Class HttpClientAbstractTest
 * @package Move\Http\Client
 */
class HttpClientAbstractTest extends TestCase
{
    /**
     * @return HttpClientAbstract|\PHPUnit_Framework_MockObject_MockObject
     */
    public function testConstruct()
    {
        /** @var HttpClientAbstract|\PHPUnit_Framework_MockObject_MockObject $instance */
        $instance = $this
            ->getMockForAbstractClass(HttpClientAbstract::class);

        $instance
            ->expects($this->any())
            ->method('request')
            ->willReturnArgument(0);

        return $instance;
    }

    /**
     * @covers HttpClientAbstract::get
     * @depends testConstruct
     * @param HttpClientAbstract $instance
     */
    public function testGet(HttpClientAbstract $instance)
    {
        $expected = 'GET';
        $returned = $instance->get([]);
        $this->assertEquals($expected, $returned);
    }

    /**
     * @covers HttpClientAbstract::delete
     * @depends testConstruct
     * @param HttpClientAbstract $instance
     */
    public function testDelete(HttpClientAbstract $instance)
    {
        $expected = 'DELETE';
        $returned = $instance->delete([]);
        $this->assertEquals($expected, $returned);
    }

    /**
     * @covers HttpClientAbstract::put
     * @depends testConstruct
     * @param HttpClientAbstract $instance
     */
    public function testPut(HttpClientAbstract $instance)
    {
        $expected = 'PUT';
        $returned = $instance->put([], []);
        $this->assertEquals($expected, $returned);
    }

    /**
     * @covers HttpClientAbstract::post
     * @depends testConstruct
     * @param HttpClientAbstract $instance
     */
    public function testPost(HttpClientAbstract $instance)
    {
        $expected = 'POST';
        $returned = $instance->post([],'');
        $this->assertEquals($expected, $returned);
    }
}
