<?php

namespace Move\Specification;

use PHPUnit\Framework\TestCase;

/**
 * Class EmailSpecificationTest
 * @package Move\Specification
 */
class EmailSpecificationTest extends TestCase
{
    /**
     * @return array
     */
    public static function provideEmails() {
        return [
            ['email@example.com', true],
            ['firstname.lastname@example.com', true],
            ['email@subdomain.example.com', true],
            ['firstname+lastname@example.com', true],
            ['email@123.123.123.123', true],
            ['“email”@example.com', true],
            ['1234567890@example.com', true],
            ['email@example-one.com', true],
            ['_______@example.com', true],
            ['email@example.name', true],
            ['email@example.museum', true],
            ['email@example.co.jp', true],
            ['firstname-lastname@example.com', true],

            ['plainaddress', false],
            ['#@%^%#$@#$@#.com', false],
            ['@example.com', false],
            ['Joe Smith <email@example.com>', false],
            ['email.example.com', false],
            ['email@example@example.com', false],
            ['.email@example.com', false],
            ['email.@example.com', false],
            ['email..email@example.com', false],
            ['あいうえお@example.com', false],
            ['email@example.com (Joe Smith)', false],
            ['email@example', false],
            ['email@-example.com', false],
            ['email@example.web', false],
            ['email@111.222.333.44444', false],
            ['email@example..com', false],
            ['Abc..123@example.com', false]
        ];
    }

    /**
     * @covers EmailSpecification::isSatisfiedBy
     * @dataProvider provideEmails
     * @param mixed $string
     * @param $expected
     */
    public function testIsSatisfiedBy($string, $expected)
    {
        $spec = new EmailSpecification();
        $this->assertEquals(
            $expected,
            $spec->isSatisfiedBy($string)
        );
    }
}
