<?php

namespace Cms\Client\Campsite;

use Cms\Client\AbstractClient;
use Cms\Client\Campsite\Model\CampsiteRestfulModel;
use Cms\Client\ClientFetchStrategy;
use Cms\Client\CmsApiIndexIterator;

/**
 * Class CampsiteClient
 * @package Cms\Client\Campsite
 */
class CampsiteClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'campsite';

    /** @var string */
    protected $fetchStrategy = ClientFetchStrategy::FETCH_ASYNC;

    /**
     * @param array $dataset
     * @return CampsiteRestfulModel
     */
    public function handleData($dataset = []) : Model\CampsiteRestfulModel
    {
        return (new CampsiteRestfulModel())->populate($dataset, true);
    }

    /**
     * @param int $scope
     * @param string $slug
     * @return \Cms\Client\Campsite\Model\CampsiteRestfulModel|null|\POM\DomainObjectInterface
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     */
    public function fetchItemBySlug(int $scope, string $slug)
    {
        $object = $this->fetchItem($slug, [
            'scope' => $scope,
        ]);
        return $object;
    }

    /**
     * @param int $scope
     * @return \Cms\Client\CmsApiIndexIterator|CampsiteRestfulModel[]
     */
    public function fetchAllBoosted(int $scope = null)
    {
        $results = $this->getBuilder()
            ->setFilter('is_boosted', true)
            ->setFilter('scope_id', $scope)
            ->getIndex(-1);
        return $results;
    }

    /**
     * @param int $addressId
     * @return null|CampsiteRestfulModel
     */
    public function fetchByAddressId(int $addressId)
    {
        $object = $this->getBuilder()
            ->setFilter('address_id', $addressId)
            ->getIndex(-1);
        if ($object->count() === 1) {
            return $object->getFirst();
        }
        return null;
    }

    /**
     * @param int $scope
     * @param string $slug
     * @return null|CampsiteRestfulModel
     */
    public function fetchLastItemWithSlug(int $scope, string $slug)
    {
        $object = $this->getBuilder()
            ->setFilter('scope_id', $scope)
            ->setFilter('slug_part', $slug)
            ->getIndex(-1);
        if ($object->count() === 1) {
            return $object->getFirst();
        }
        return null;
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|CampsiteRestfulModel[]
     * @throws \LogicException
     * @throws \InvalidArgumentException
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }
}
