<?php

namespace Cms\Client\CmsScan;

use Cms\Client\AbstractClient;
use Cms\Client\CmsApiIndexIterator;
use Cms\Client\CmsScan\Model\CmsScanStatusRestfulModel;

/**
 * Class CmsScnaStatusClient
 * @package Cms\Client\CmsScan
 */
class CmsScanStatusClient extends AbstractClient
{

    /** @var string */
    protected $basePath = 'cms-scan/status';

    /**
     * @param array $dataset
     * @return \Cms\Client\CmsScan\Model\CmsScanStatusRestfulModel
     */
    public function handleData($dataset = []) : CmsScanStatusRestfulModel
    {
        return (new CmsScanStatusRestfulModel())->populate($dataset, true);
    }

    /**
     * @param array $queryParams
     * @return CmsApiIndexIterator|CmsScanStatusRestfulModel[]
     * @throws \UnexpectedValueException
     * @throws \RuntimeException
     * @throws \Move\Http\Client\Exception\HttpServerException
     * @throws \Move\Http\Client\Exception\HttpRequestException
     * @throws \Move\Http\Client\Exception\HttpClientException
     * @throws \LogicException
     * @throws \InvalidArgumentException
     */
    public function getIndexWithParams($queryParams)
    {
        $result = $this->loadIndexFromClient($this->basePath, $queryParams);
        return $result;
    }
}
