<?php


namespace Cms\Client\Command\Geodata\Command;

use Move\Command\Command\FetchCommand;

/**
 * Class FetchCityCommand
 * @package Cms\Client\Command\Geodata\Command
 */
class FetchCityCommand extends FetchCommand
{

    /** @var  string */
    private $slugPart;

    /** @var  string */
    private $admin1Code;

    /** @var  string */
    private $admin2Code;

    /**
     * FetchCityCommand constructor.
     * @param int|string $ident
     */
    public function __construct($ident)
    {
        parent::__construct($ident);
    }

    /**
     * @return string|null
     */
    public function getSlugPart()
    {
        return $this->slugPart;
    }

    /**
     * @param string $slugPart
     * @return $this
     */
    public function setSlugPart(string $slugPart)
    {
        $this->slugPart = $slugPart;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAdmin1Code()
    {
        return $this->admin1Code;
    }

    /**
     * @param string $admin1Code
     * @return $this
     */
    public function setAdmin1Code(string $admin1Code)
    {
        $this->admin1Code = $admin1Code;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAdmin2Code()
    {
        return $this->admin2Code;
    }

    /**
     * @param string $admin2Code
     * @return $this
     */
    public function setAdmin2Code(string $admin2Code)
    {
        $this->admin2Code = $admin2Code;
        return $this;
    }
}
